mod Ex03 logic: 'cl'

incl Mtexg

loc rem 
  \para \bf  3. CVICENIE Z PREDMETU 1-AIN-470 SPECIFIKACIA A VERIFIKACIA 
  PROGRAMOV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 5.81.19 
  \para* \it  Datum:  \end stvrtok 4.3.2010 
  \para* \it  WWW:  \end 
  http://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/0910ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Uvodna poznamka.  \end Toto cvicenie je venovane Peanovej 
  aritmetike. Zadanie sa sklada z tychto suborov: 
  \items 
   \item \para Subory \it  mtex*.cl  \end obsahuju makra pre CL-TeX. 
   \item \para Subory \it  ex*.cl  \end obsahuju ulohy, ktore mate riesit na 
         tomto cviceni. 
   \item \para Subory \it  mlogic*.cl  \end obsahuju popis verifikacneho systemu 
         CL. 
   \item \para Subor \it  msyntax.cl  \end obsahuje syntax systemu CL. 
  \end
  \para Tieto subory sa musia skompilovat v spravnom poradi; presny postup je 
  uvedeny v subore \it  readme.txt  \end. 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end J. Komara and P. J. Voda. Metamathematics of 
         Computer Programming. 2001. 
  \end

rem 
  \para \bf  Chapter. Peano Arithmetic.  \end 

rem 
  \para \bf  Section. Basic Theorems in PA.  \end 

theory Peano logic: 'fol_def'

rem 
  \para \bf  Definition.  \end The language of Peano arithmetic consists of the 
  following four symbols: 

fun/0 Z 'Tex_f0_g_pa_z'

fun Ss 'Tex_f1_g_pa_ss'

fun/2 Plus 'Tex_f2_g_pa_plus'

fun/2 Times 'Tex_f2_g_pa_times'

rem 
  \para \bf  Definition.  \end The axioms of Peano arithmetic consists of the 
  following six axioms 

axiom Succ_zero
  Ss(x) != Z

axiom Succ_injective
  Ss(x) = Ss(y) -> x = y

axiom Plus_zero_left
  Plus(Z,y) = y

axiom Plus_succ_left
  Plus(Ss(x),y) = Ss Plus(x,y)

axiom Times_zero_left
  Times(Z,y) = Z

axiom Times_succ_left
  Times(Ss(x),y) = Plus(Times(x,y),y)

rem 
  \para \header* pred R 'Tex2_g_appl_subst_sb' \end together with all 
  mathematical induction axioms 
  \eq* 
    R(Z) & \a x(R(x) -> R Ss(x)) -> \a xR(x)
  \end
  \para The induction formula \ft R(x) \end may contain, in addition to the 
  induction variable \ft x \end, zero or more free variables as parameters. 

rem 
  \para \bf  [CL] Remark.  \end The following form of the axiom \it  
  Succ_injective  \end you may find very useful in the subsequent exercises. 

lemma Succ_injective1
  Ss(x) = Ss(y) <-> x = y
proof 
 split* Ss(x) = Ss(y) <-> x = y.2,0,0
  use Succ_injective; x; y proved.
  proved..

rem 
  \para \bf  Case analysis on zero and positive numbers.  \end Prove 
  \eq* 
    x = Z \/ \e y x = Ss(y)
  \end
  \para \it  Hint.  \end Use the following induction axiom: 

axiom Iax_case_analysis
  (Z = Z \/ \e y Z = Ss(y)) & 
  \a x(x = Z \/ \e y x = Ss(y) -> Ss(x) = Z \/ \e y Ss(x) = Ss(y)) -> 
  \a x(x = Z \/ \e y x = Ss(y))

thm Case_analysis
  x = Z \/ \e y x = Ss(y)

rem 
  \para \bf  Nullpoints of addition.  \end Prove 
  \eq* 
    Plus(x,y) = Z <-> x = Z & y = Z
  \end
  \para \it  Hint.  \end By case analysis on \ft x \end. 

thm Plus_is_zero
  Plus(x,y) = Z <-> x = Z & y = Z

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Plus(x,Z) = x
  \end
  \para \it  Hint.  \end Use the following induction axiom: 

axiom Iax_plus_zero_right
  Plus(Z,Z) = Z & \a x(Plus(x,Z) = x -> Plus(Ss(x),Z) = Ss(x)) -> 
  \a x Plus(x,Z) = x

thm Plus_zero_right
  Plus(x,Z) = x

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Plus(x,Ss(y)) = Ss Plus(x,y)
  \end

thm Plus_succ_right
  Plus(x,Ss(y)) = Ss Plus(x,y)

rem 
  \para \bf  Addition is commutative.  \end Prove 
  \eq* 
    Plus(x,y) = Plus(y,x)
  \end

thm Plus_comm
  Plus(x,y) = Plus(y,x)

rem 
  \para \bf  Addition is associative.  \end Prove 
  \eq* 
    Plus(x,Plus(y,z)) = Plus(Plus(x,y),z)
  \end

thm Plus_assoc
  Plus(x,Plus(y,z)) = Plus(Plus(x,y),z)

rem 
  \para \bf  Cancellation rules for addition.  \end Prove 
  \eq* 
    Plus(z,x) = Plus(z,y) -> x = y
  \end
  \eq* 
    Plus(x,z) = Plus(y,z) -> x = y
  \end

thm Plus_cancel_left
  Plus(z,x) = Plus(z,y) -> x = y

thm Plus_cancel_right
  Plus(x,z) = Plus(y,z) -> x = y

end theory Peano

